# CV Maker PHP

تطبيق ويب لإنشاء السير الذاتية باستخدام الذكاء الاصطناعي - تم تحويله من تطبيق Python Desktop إلى تطبيق ويب PHP.

## المميزات

- ✅ **واجهة مستخدم حديثة**: تصميم متجاوب وسهل الاستخدام
- ✅ **تكامل الذكاء الاصطناعي**: دعم OpenAI و OpenRouter لتحليل الوصف الوظيفي
- ✅ **قوالب متعددة**: قوالب حديثة ومهنية للسيرة الذاتية
- ✅ **إدارة البيانات**: حفظ وتحميل البيانات الشخصية والإعدادات
- ✅ **توليد ملفات Word**: إنشاء ملفات .docx منسقة ومهنية
- ✅ **دعم اللغة العربية**: واجهة ومحتوى باللغة العربية
- ✅ **نظام إدارة شامل**: إدارة الخبرات، الشهادات، واللغات

## المتطلبات

- PHP 8.1 أو أحدث
- Composer
- مكتبات PHP التالية:
  - `phpoffice/phpword` - لإنشاء ملفات Word
  - `guzzlehttp/guzzle` - للطلبات HTTP
  - `orhanerday/open-ai` - للتكامل مع OpenAI

## التثبيت

1. **استنساخ المشروع**:
   ```bash
   git clone [repository-url]
   cd cv_maker_php
   ```

2. **تثبيت التبعيات**:
   ```bash
   composer install
   ```

3. **إعداد الصلاحيات**:
   ```bash
   chmod -R 755 public/
   chmod -R 777 storage/
   chmod -R 777 downloads/
   ```

4. **تشغيل الخادم المحلي**:
   ```bash
   cd public
   php -S localhost:8080
   ```

5. **فتح التطبيق**:
   افتح المتصفح وانتقل إلى `http://localhost:8080`

## هيكل المشروع

```
cv_maker_php/
├── config/
│   └── config.php              # إعدادات التطبيق
├── public/
│   ├── index.php               # نقطة الدخول الرئيسية
│   └── assets/
│       ├── css/style.css       # ملفات التصميم
│       ├── js/app.js          # JavaScript الرئيسي
│       └── images/            # الصور والأيقونات
├── src/
│   ├── Controllers/
│   │   └── CVController.php    # تحكم رئيسي
│   └── Services/
│       ├── OpenAIService.php   # خدمة الذكاء الاصطناعي
│       ├── DocumentGenerator.php # توليد المستندات
│       └── SettingsManager.php   # إدارة الإعدادات
├── templates/
│   ├── layout.php             # قالب التخطيط الأساسي
│   └── home.php              # الصفحة الرئيسية
├── storage/                   # ملفات التخزين
├── downloads/                 # ملفات التحميل
└── vendor/                   # مكتبات Composer
```

## الاستخدام

### 1. إدخال المعلومات الشخصية
- املأ البيانات الأساسية: الاسم، المسمى الوظيفي، البريد الإلكتروني، إلخ
- أضف معلومات التواصل والموقع

### 2. إضافة الخبرات
- انقر على تبويب "Experience"
- اضغط "Add Experience" لإضافة خبرة جديدة
- املأ تفاصيل المنصب، الشركة، والمدة الزمنية

### 3. إعداد الذكاء الاصطناعي
- انتقل إلى تبويب "AI Settings"
- اختر المزود (OpenAI أو OpenRouter)
- أدخل مفتاح API الخاص بك
- اختبر الاتصال باستخدام "Test Connection"

### 4. اختيار القالب
- انتقل إلى تبويب "Templates"
- اختر القالب المفضل (Modern أو Professional)

### 5. توليد السيرة الذاتية
- انتقل إلى تبويب "Generate CV"
- الصق الوصف الوظيفي في النص المخصص
- اضغط "Generate CV" لإنشاء السيرة الذاتية

## إعدادات الذكاء الاصطناعي

### OpenAI
```php
$settings = [
    'provider' => 'openai',
    'api_key' => 'your-openai-api-key',
    'model' => 'gpt-3.5-turbo'
];
```

### OpenRouter
```php
$settings = [
    'provider' => 'openrouter',
    'api_key' => 'your-openrouter-api-key',
    'model' => 'openai/gpt-3.5-turbo',
    'http_referer' => 'https://yoursite.com',
    'x_title' => 'CV Maker'
];
```

## API المتاحة

### إنشاء السيرة الذاتية
```
POST /generate-cv
Content-Type: multipart/form-data

Parameters:
- name: الاسم الكامل
- title: المسمى الوظيفي
- email: البريد الإلكتروني
- job_description: الوصف الوظيفي
- template: نوع القالب
```

### حفظ الإعدادات
```
POST /save-settings
Content-Type: application/x-www-form-urlencoded

Parameters:
- setting_type: نوع الإعداد
- data: بيانات JSON
```

### اختبار API
```
POST /test-api
Content-Type: multipart/form-data

Parameters:
- api_key: مفتاح API
- provider: المزود
- model: النموذج
```

## الاختبار

تشغيل اختبارات التحقق من الوظائف:

```bash
php test_document_generation.php
```

## الأمان

- مفاتيح API يتم تخزينها محلياً في ملفات JSON
- لا يتم مشاركة البيانات الحساسة مع خوادم خارجية
- تشفير كلمات المرور في قاعدة البيانات (إذا تم استخدامها)

## المساهمة

1. Fork المشروع
2. إنشاء فرع للميزة الجديدة (`git checkout -b feature/AmazingFeature`)
3. Commit التغييرات (`git commit -m 'Add some AmazingFeature'`)
4. Push إلى الفرع (`git push origin feature/AmazingFeature`)
5. فتح Pull Request

## الترخيص

هذا المشروع مرخص تحت رخصة MIT - انظر ملف [LICENSE](LICENSE) للتفاصيل.

## المقارنة مع النسخة الأصلية Python

| الميزة | Python (الأصلي) | PHP (الجديد) |
|--------|-----------------|--------------|
| **النوع** | تطبيق سطح مكتب | تطبيق ويب |
| **الواجهة** | Tkinter GUI | HTML/CSS/JS |
| **النشر** | تطبيق محلي | خادم ويب |
| **الوصول** | جهاز واحد | متعدد الأجهزة |
| **التحديث** | إعادة تثبيت | تحديث الخادم |
| **المشاركة** | نسخ الملفات | روابط مباشرة |

## الدعم الفني

للحصول على المساعدة أو الإبلاغ عن مشاكل:

1. افتح Issue في GitHub
2. تأكد من تضمين:
   - وصف المشكلة
   - خطوات إعادة الإنتاج
   - رسائل الخطأ (إن وجدت)
   - إصدار PHP المستخدم

## التطوير المستقبلي

- [ ] دعم قواعد البيانات (MySQL/PostgreSQL)
- [ ] نظام المستخدمين والمصادقة
- [ ] المزيد من القوالب
- [ ] تصدير PDF مباشر
- [ ] API RESTful كامل
- [ ] لوحة تحكم إدارية
- [ ] دعم اللغات المتعددة
- [ ] تكامل مع LinkedIn API
