<?php

// Configuration file for CV Maker PHP Application

return [
    // Application settings
    'app' => [
        'name' => 'CV Maker',
        'version' => '1.0.0',
        'debug' => true,
        'timezone' => 'UTC',
    ],

    // File paths
    'paths' => [
        'storage' => __DIR__ . '/../storage',
        'settings' => __DIR__ . '/../storage/settings',
        'temp' => __DIR__ . '/../storage/temp',
        'downloads' => __DIR__ . '/../public/downloads',
        'templates' => __DIR__ . '/../templates',
        'assets' => __DIR__ . '/../public/assets',
    ],

    // Session settings
    'session' => [
        'name' => 'cv_maker_session',
        'lifetime' => 3600, // 1 hour
        'path' => '/',
        'domain' => '',
        'secure' => false,
        'httponly' => true,
    ],

    // File settings
    'files' => [
        'max_upload_size' => '10M',
        'allowed_extensions' => ['jpg', 'jpeg', 'png', 'gif'],
        'temp_file_lifetime' => 3600, // 1 hour
    ],

    // Default CV settings
    'cv_defaults' => [
        'section_order' => [
            'profile',
            'experiences', 
            'skills',
            'interests',
            'education',
            'certifications',
            'languages'
        ],
        'section_names' => [
            'profile' => 'Professional Summary',
            'skills' => 'Skills',
            'interests' => 'Interests'
        ],
        'templates' => [
            'modern' => 'Modern Template',
            'professional' => 'Professional Template'
        ]
    ],

    // API settings
    'api' => [
        'openai' => [
            'base_url' => 'https://api.openai.com/v1',
            'timeout' => 30,
            'max_retries' => 3,
        ],
        'openrouter' => [
            'base_url' => 'https://openrouter.ai/api/v1',
            'timeout' => 30,
            'max_retries' => 3,
        ]
    ],

    // Security settings
    'security' => [
        'csrf_token_name' => 'csrf_token',
        'csrf_token_lifetime' => 3600,
        'max_login_attempts' => 5,
        'login_attempt_timeout' => 900, // 15 minutes
    ]
];
