<?php

// CV Maker PHP - Main Entry Point

// Enable error reporting for development
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include Composer autoloader
require_once __DIR__ . '/../vendor/autoload.php';

// Load configuration
$config = include __DIR__ . '/../config/config.php';

// Start session
session_start();

// Set timezone
date_default_timezone_set($config['app']['timezone']);

// Simple routing
$request_uri = $_SERVER['REQUEST_URI'];
$path = parse_url($request_uri, PHP_URL_PATH);

// Remove leading slash
$path = ltrim($path, '/');

// Import controller
use CVMaker\Controllers\CVController;

// Initialize controller
$controller = new CVController();

// Route requests
switch ($path) {
    case '':
    case 'index.php':
        $controller->index();
        break;
        
    case 'generate-cv':
        $controller->generateCV();
        break;
        
    case 'save-settings':
        $controller->saveSettings();
        break;
        
    case 'test-api':
        $controller->testAPI();
        break;
        
    case 'reset-settings':
        $controller->resetSettings();
        break;
        
    default:
        // Check if it's a static file request
        if (preg_match('/\.(css|js|png|jpg|jpeg|gif|ico|svg)$/', $path)) {
            // Let the web server handle static files
            return false;
        }
        
        // 404 Not Found
        http_response_code(404);
        echo "404 - Page Not Found";
        break;
}
