<?php
// Start output buffering to capture content
ob_start();
?>

<div class="card">
    <!-- Tab Navigation -->
    <div class="tab-nav">
        <button type="button" data-tab="personal-info" class="active">Personal Info</button>
        <button type="button" data-tab="experience">Experience</button>
        <button type="button" data-tab="education">Education</button>
        <button type="button" data-tab="certifications">Certifications</button>
        <button type="button" data-tab="languages">Languages</button>
        <button type="button" data-tab="ai-settings">AI Settings</button>
        <button type="button" data-tab="templates">Templates</button>
        <button type="button" data-tab="generate">Generate CV</button>
    </div>

    <form id="cv-form" method="POST" action="/generate-cv">
        <!-- Personal Information Tab -->
        <div id="personal-info" class="tab-content active">
            <h3 style="margin-bottom: 1.5rem; color: var(--primary-color);">Personal Information</h3>
            
            <div class="form-row">
                <div class="form-group">
                    <label for="name" class="form-label">Full Name *</label>
                    <input type="text" id="name" name="name" class="form-input" 
                           value="<?= htmlspecialchars($userData['name'] ?? '') ?>" required>
                </div>
                <div class="form-group">
                    <label for="title" class="form-label">Professional Title</label>
                    <input type="text" id="title" name="title" class="form-input" 
                           value="<?= htmlspecialchars($userData['title'] ?? '') ?>" 
                           placeholder="e.g., Software Engineer">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="email" class="form-label">Email Address</label>
                    <input type="email" id="email" name="email" class="form-input" 
                           value="<?= htmlspecialchars($userData['email'] ?? '') ?>">
                </div>
                <div class="form-group">
                    <label for="phone" class="form-label">Phone Number</label>
                    <input type="tel" id="phone" name="phone" class="form-input" 
                           value="<?= htmlspecialchars($userData['phone'] ?? '') ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="location" class="form-label">Location</label>
                    <input type="text" id="location" name="location" class="form-input" 
                           value="<?= htmlspecialchars($userData['location'] ?? '') ?>" 
                           placeholder="City, Country">
                </div>
                <div class="form-group">
                    <label for="linkedin" class="form-label">LinkedIn Profile</label>
                    <input type="url" id="linkedin" name="linkedin" class="form-input" 
                           value="<?= htmlspecialchars($userData['linkedin'] ?? '') ?>" 
                           placeholder="https://linkedin.com/in/yourprofile">
                </div>
            </div>
        </div>

        <!-- Experience Tab -->
        <div id="experience" class="tab-content">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
                <h3 style="margin: 0; color: var(--primary-color);">Work Experience</h3>
                <button type="button" class="btn btn-primary" data-action="add" data-list="experiences">
                    Add Experience
                </button>
            </div>
            
            <div id="experiences-list" class="list-container">
                <?php if (empty($userData['experiences'])): ?>
                    <div style="padding: 2rem; text-align: center; color: var(--text-secondary);">
                        No experience added yet. Click "Add Experience" to get started.
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Education Tab -->
        <div id="education" class="tab-content">
            <h3 style="margin-bottom: 1.5rem; color: var(--primary-color);">Education</h3>
            
            <div class="form-row">
                <div class="form-group">
                    <label for="degree" class="form-label">Degree</label>
                    <input type="text" id="degree" name="degree" class="form-input" 
                           value="<?= htmlspecialchars($userData['degree'] ?? '') ?>" 
                           placeholder="e.g., Bachelor of Science in Computer Science">
                </div>
                <div class="form-group">
                    <label for="university" class="form-label">University/Institution</label>
                    <input type="text" id="university" name="university" class="form-input" 
                           value="<?= htmlspecialchars($userData['university'] ?? '') ?>">
                </div>
            </div>
        </div>

        <!-- Certifications Tab -->
        <div id="certifications" class="tab-content">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
                <h3 style="margin: 0; color: var(--primary-color);">Certifications</h3>
                <button type="button" class="btn btn-primary" data-action="add" data-list="certifications">
                    Add Certification
                </button>
            </div>
            
            <div id="certifications-list" class="list-container">
                <?php if (empty($userData['certifications'])): ?>
                    <div style="padding: 2rem; text-align: center; color: var(--text-secondary);">
                        No certifications added yet. Click "Add Certification" to get started.
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Languages Tab -->
        <div id="languages" class="tab-content">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
                <h3 style="margin: 0; color: var(--primary-color);">Languages</h3>
                <button type="button" class="btn btn-primary" data-action="add" data-list="languages">
                    Add Language
                </button>
            </div>
            
            <div id="languages-list" class="list-container">
                <?php if (empty($userData['languages'])): ?>
                    <div style="padding: 2rem; text-align: center; color: var(--text-secondary);">
                        No languages added yet. Click "Add Language" to get started.
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- AI Settings Tab -->
        <div id="ai-settings" class="tab-content">
            <h3 style="margin-bottom: 1.5rem; color: var(--primary-color);">AI Settings</h3>
            
            <form id="ai-settings-form">
                <div class="form-group">
                    <label for="provider" class="form-label">AI Provider</label>
                    <select id="provider" name="provider" class="form-select">
                        <option value="openai" <?= ($aiSettings['provider'] ?? 'openai') === 'openai' ? 'selected' : '' ?>>OpenAI</option>
                        <option value="openrouter" <?= ($aiSettings['provider'] ?? '') === 'openrouter' ? 'selected' : '' ?>>OpenRouter</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="api_key" class="form-label">API Key *</label>
                    <input type="password" id="api_key" name="api_key" class="form-input" 
                           value="<?= htmlspecialchars($aiSettings['api_key'] ?? '') ?>" required>
                    <small style="color: var(--text-secondary);">Your API key is stored locally and never shared.</small>
                </div>

                <div class="form-group">
                    <label for="model" class="form-label">AI Model</label>
                    <input type="text" id="model" name="model" class="form-input" 
                           value="<?= htmlspecialchars($aiSettings['model'] ?? 'gpt-3.5-turbo') ?>" 
                           placeholder="gpt-3.5-turbo">
                </div>

                <div class="form-group">
                    <label for="excluded_terms" class="form-label">Excluded Terms</label>
                    <input type="text" id="excluded_terms" name="excluded_terms" class="form-input" 
                           value="<?= htmlspecialchars(implode(', ', $aiSettings['excluded_terms'] ?? [])) ?>" 
                           placeholder="word1, word2, word3">
                    <small style="color: var(--text-secondary);">Words to avoid in AI-generated content (comma-separated).</small>
                </div>

                <!-- OpenRouter specific fields -->
                <div id="openrouter-fields" style="<?= ($aiSettings['provider'] ?? 'openai') !== 'openrouter' ? 'display: none;' : '' ?>">
                    <div class="form-group">
                        <label for="http_referer" class="form-label">HTTP Referer (Optional)</label>
                        <input type="url" id="http_referer" name="http_referer" class="form-input" 
                               value="<?= htmlspecialchars($aiSettings['http_referer'] ?? '') ?>">
                    </div>

                    <div class="form-group">
                        <label for="x_title" class="form-label">X-Title (Optional)</label>
                        <input type="text" id="x_title" name="x_title" class="form-input" 
                               value="<?= htmlspecialchars($aiSettings['x_title'] ?? '') ?>">
                    </div>
                </div>

                <div style="display: flex; gap: 1rem;">
                    <button type="submit" class="btn btn-primary">Save Settings</button>
                    <button type="button" id="test-api-btn" class="btn btn-secondary">Test Connection</button>
                </div>
            </form>
        </div>

        <!-- Templates Tab -->
        <div id="templates" class="tab-content">
            <h3 style="margin-bottom: 1.5rem; color: var(--primary-color);">Choose Template</h3>
            
            <div class="template-grid">
                <div class="template-card <?= ($templatePreference ?? 'modern') === 'modern' ? 'selected' : '' ?>" 
                     data-template="modern">
                    <div class="template-preview" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: 600;">
                        Modern Template Preview
                    </div>
                    <div class="template-info">
                        <div class="template-name">Modern Template</div>
                        <div class="template-description">Clean and contemporary design with modern styling</div>
                    </div>
                </div>

                <div class="template-card <?= ($templatePreference ?? '') === 'professional' ? 'selected' : '' ?>" 
                     data-template="professional">
                    <div class="template-preview" style="background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: 600;">
                        Professional Template Preview
                    </div>
                    <div class="template-info">
                        <div class="template-name">Professional Template</div>
                        <div class="template-description">Traditional and formal layout for corporate environments</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Generate CV Tab -->
        <div id="generate" class="tab-content">
            <h3 style="margin-bottom: 1.5rem; color: var(--primary-color);">Generate Your CV</h3>
            
            <div class="form-group">
                <label for="job_description" class="form-label">Job Description *</label>
                <textarea id="job_description" name="job_description" class="form-textarea" 
                          style="min-height: 200px;" required 
                          placeholder="Paste the job description here. The AI will analyze it and tailor your CV content accordingly."></textarea>
                <small style="color: var(--text-secondary);">
                    Paste the job description you're applying for. The AI will analyze it and generate relevant content for your CV.
                </small>
            </div>

            <div style="text-align: center; margin-top: 2rem;">
                <button type="submit" id="generate-cv-btn" class="btn btn-primary btn-lg">
                    Generate CV
                </button>
            </div>

            <div style="margin-top: 2rem; padding: 1.5rem; background: var(--background-color); border-radius: var(--border-radius);">
                <h4 style="margin-bottom: 1rem; color: var(--text-primary);">How it works:</h4>
                <ol style="color: var(--text-secondary); line-height: 1.8;">
                    <li>Fill in your personal information and experience details</li>
                    <li>Configure your AI settings with a valid API key</li>
                    <li>Choose your preferred template</li>
                    <li>Paste the job description you're applying for</li>
                    <li>Click "Generate CV" to create a tailored resume</li>
                </ol>
            </div>
        </div>
    </form>
</div>

<?php
// Capture the content and assign to variable
$content = ob_get_clean();

// Set page title
$title = 'CV Maker - Create Professional CVs with AI';

// Add inline JavaScript to populate form data
$inlineJS = "
// Populate form data from PHP
document.addEventListener('DOMContentLoaded', function() {
    if (window.cvApp) {
        // Set user data
        cvApp.userData = " . json_encode($userData) . ";
        cvApp.aiSettings = " . json_encode($aiSettings) . ";
        cvApp.sectionNames = " . json_encode($sectionNames) . ";
        cvApp.sectionOrder = " . json_encode($sectionOrder) . ";
        
        // Populate lists
        cvApp.populateList('experiences', cvApp.userData.experiences || []);
        cvApp.populateList('certifications', cvApp.userData.certifications || []);
        cvApp.populateList('languages', cvApp.userData.languages || []);
        
        // Show/hide OpenRouter fields based on provider
        const providerSelect = document.getElementById('provider');
        const openrouterFields = document.getElementById('openrouter-fields');
        
        function toggleOpenRouterFields() {
            if (providerSelect.value === 'openrouter') {
                openrouterFields.style.display = 'block';
            } else {
                openrouterFields.style.display = 'none';
            }
        }
        
        providerSelect.addEventListener('change', toggleOpenRouterFields);
        toggleOpenRouterFields(); // Initial call
    }
});
";

// Include the layout template
include __DIR__ . '/layout.php';
?>
