<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'CV Maker' ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/assets/images/favicon.ico">
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Main CSS -->
    <link rel="stylesheet" href="/assets/css/style.css">
    
    <!-- Additional CSS -->
    <?php if (isset($additionalCSS)): ?>
        <?php foreach ($additionalCSS as $css): ?>
            <link rel="stylesheet" href="<?= $css ?>">
        <?php endforeach; ?>
    <?php endif; ?>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="container">
            <h1><?= $config['app']['name'] ?? 'CV Maker' ?></h1>
            <p class="text-center" style="color: var(--text-secondary); margin-top: 0.5rem;">
                Create professional CVs with AI assistance
            </p>
        </div>
    </header>

    <!-- Main Content -->
    <main class="main-content">
        <div class="container">
            <?= $content ?? '' ?>
        </div>
    </main>

    <!-- Footer -->
    <footer style="background: var(--card-background); border-top: 1px solid var(--border-color); padding: 1rem 0; margin-top: 2rem;">
        <div class="container text-center">
            <p style="color: var(--text-secondary); margin: 0;">
                CV Maker PHP v<?= $config['app']['version'] ?? '1.0.0' ?> - 
                Converted from Python Desktop Application
            </p>
        </div>
    </footer>

    <!-- Modals -->
    <div id="list-item-modal" class="modal-overlay">
        <div class="modal">
            <div class="modal-header">
                <h3 id="modal-title" class="modal-title">Add Item</h3>
                <button type="button" class="modal-close">&times;</button>
            </div>
            <div class="modal-body">
                <form id="list-item-form">
                    <div id="modal-form-fields">
                        <!-- Dynamic form fields will be inserted here -->
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="cvApp.closeModal()">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="saveListItem()">Save</button>
            </div>
        </div>
    </div>

    <!-- Loading Overlay -->
    <div id="loading-overlay" class="modal-overlay" style="display: none;">
        <div style="background: var(--card-background); padding: 2rem; border-radius: var(--border-radius); text-align: center;">
            <div class="spinner" style="width: 2rem; height: 2rem; margin: 0 auto 1rem;"></div>
            <p>Processing your request...</p>
        </div>
    </div>

    <!-- Main JavaScript -->
    <script src="/assets/js/app.js"></script>
    
    <!-- Additional JavaScript -->
    <?php if (isset($additionalJS)): ?>
        <?php foreach ($additionalJS as $js): ?>
            <script src="<?= $js ?>"></script>
        <?php endforeach; ?>
    <?php endif; ?>

    <!-- Inline JavaScript -->
    <?php if (isset($inlineJS)): ?>
        <script>
            <?= $inlineJS ?>
        </script>
    <?php endif; ?>
</body>
</html>
