<?php

// Test script for document generation functionality
require_once __DIR__ . '/vendor/autoload.php';

use CVMaker\Services\DocumentGenerator;
use CVMaker\Services\SettingsManager;

echo "Testing CV Maker PHP Document Generation...\n\n";

// Test data
$userData = [
    'name' => 'أحمد محمد علي',
    'title' => 'مطور برمجيات',
    'email' => 'ahmed@example.com',
    'phone' => '+966501234567',
    'location' => 'الرياض، السعودية',
    'linkedin' => 'https://linkedin.com/in/ahmed-ali',
    'university' => 'جامعة الملك سعود',
    'degree' => 'بكالوريوس علوم الحاسب',
    'experiences' => [
        [
            'position' => 'مطور برمجيات أول',
            'company' => 'شركة التقنية المتقدمة',
            'duration' => 'يناير 2020 - الحاضر',
            'details' => [
                'تطوير تطبيقات ويب باستخدام PHP و JavaScript',
                'إدارة فريق من 5 مطورين',
                'تحسين الأداء بنسبة 40%'
            ]
        ]
    ],
    'certifications' => [
        [
            'name' => 'AWS Certified Developer',
            'authority' => 'Amazon Web Services'
        ]
    ],
    'languages' => [
        [
            'name' => 'العربية',
            'proficiency' => 'Native'
        ],
        [
            'name' => 'الإنجليزية',
            'proficiency' => 'Advanced'
        ]
    ]
];

$aiData = [
    'profile' => 'مطور برمجيات متمرس مع خبرة واسعة في تطوير التطبيقات الحديثة وإدارة الفرق التقنية.',
    'skills' => [
        'PHP',
        'JavaScript',
        'Python',
        'React',
        'Node.js',
        'MySQL',
        'AWS',
        'Docker'
    ],
    'interests' => [
        'الذكاء الاصطناعي',
        'تطوير التطبيقات المحمولة',
        'الحوسبة السحابية'
    ]
];

$sectionNames = [
    'profile' => 'الملف الشخصي',
    'skills' => 'المهارات',
    'interests' => 'الاهتمامات'
];

$sectionOrder = [
    'profile',
    'experiences',
    'skills',
    'interests',
    'education',
    'certifications',
    'languages'
];

try {
    echo "1. Creating DocumentGenerator instance...\n";
    $documentGenerator = new DocumentGenerator();
    
    echo "2. Generating CV document...\n";
    $phpWord = $documentGenerator->generateCV(
        $userData,
        $aiData,
        $sectionNames,
        $sectionOrder,
        'modern'
    );
    
    echo "3. Saving document...\n";
    $testFilePath = __DIR__ . '/test_cv.docx';
    $result = $documentGenerator->saveDocument($testFilePath);
    
    if ($result['success']) {
        echo "✅ SUCCESS: Document saved successfully to: $testFilePath\n";
        echo "File size: " . formatBytes(filesize($testFilePath)) . "\n";
    } else {
        echo "❌ ERROR: " . $result['message'] . "\n";
    }
    
    echo "\n4. Testing SettingsManager...\n";
    $settingsManager = new SettingsManager();
    
    // Test saving settings
    $testSettings = ['test_key' => 'test_value', 'number' => 123];
    $saveResult = $settingsManager->saveSettings('test_settings', $testSettings);
    
    if ($saveResult) {
        echo "✅ Settings saved successfully\n";
        
        // Test loading settings
        $loadedSettings = $settingsManager->loadSettings('test_settings');
        if ($loadedSettings === $testSettings) {
            echo "✅ Settings loaded successfully\n";
        } else {
            echo "❌ Settings loading failed\n";
        }
        
        // Clean up test settings
        $settingsManager->deleteSetting('test_settings');
        echo "✅ Test settings cleaned up\n";
    } else {
        echo "❌ Settings saving failed\n";
    }
    
    echo "\n🎉 All tests completed successfully!\n";
    
} catch (Exception $e) {
    echo "❌ ERROR: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

function formatBytes($size, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');
    
    for ($i = 0; $size > 1024 && $i < count($units) - 1; $i++) {
        $size /= 1024;
    }
    
    return round($size, $precision) . ' ' . $units[$i];
}
